/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UShape;

public class URectangle
extends AbstractShadowable
implements Scalable {
    private final double width;
    private final double height;
    private final double rx;
    private final double ry;

    @Override
    public UShape getScaled(double scale) {
        if (scale == 1.0) {
            return this;
        }
        URectangle result = new URectangle(this.width * scale, this.height * scale, this.rx * scale, this.ry * scale);
        ((AbstractShadowable)result).setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public URectangle(double width, double height) {
        this(width, height, 0.0, 0.0);
    }

    public URectangle(double width, double height, double rx, double ry) {
        if (width == 0.0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.rx = rx;
        this.ry = ry;
    }

    public URectangle(Dimension2D dim) {
        this(dim.getWidth(), dim.getHeight());
    }

    public String toString() {
        return "width=" + this.width + " height=" + this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getRx() {
        return this.rx;
    }

    public double getRy() {
        return this.ry;
    }

    public URectangle clip(UClip clip) {
        return this;
    }

    public MinMax getMinMax() {
        return MinMax.fromMax(this.width, this.height);
    }
}

